export const createFilterablePostUrl = (key, postUrl, value) => {
    let categoryKey = `${key}=`
    const index = postUrl.current.indexOf(categoryKey);
    if(index == -1) {
        postUrl.current = `&${key}=${value?.slug || value.name}` + postUrl.current 
    } else {
        if(!value?.isChecked) {
            let addMultiple = index + categoryKey.length;
            postUrl.current = postUrl.current.slice(0, addMultiple) + `${value?.slug || value.name},` + postUrl.current.slice(addMultiple);
        } else if(value?.isChecked) {
            let beforeComma = `,${value?.slug || value.name}`; 
            let afterComma = `${value?.slug || value.name},`;
            let withoutComma = `${value?.slug || value.name}`;
            let x = postUrl.current.includes(afterComma);
            let y = postUrl.current.includes(beforeComma);
            postUrl.current = postUrl.current?.replace(x ? afterComma : y ? beforeComma : `&${key}=${withoutComma}`, "")
        }
    }
    return postUrl;
}

export const createAttributePostUrl = (postUrl, key, value) => {
    let isAttributeKey = postUrl.current.indexOf('attributes=');
    if(isAttributeKey == -1) {
        postUrl.current = postUrl.current + `&attributes=${key}:${value.name}`
    } else {
        if(!value?.isChecked) {
            if(postUrl.current.includes(key)) {
                let replaceableValue = postUrl.current.split(key)[1].split('&')[0];
                postUrl.current = postUrl.current.replace(replaceableValue, `:${value.name}`)
            } else {
                postUrl.current = postUrl.current + `;${key}:${value.name}`
            }
        } else if(value?.isChecked) {
            let beforeSemicolon = `;${key}:${value.name}`; 
            let afterSemicolon = `${key}:${value.name};`;
            let withoutSemicolon = `${key}:${value.name}`;
            let x = postUrl.current.includes(afterSemicolon);
            let y = postUrl.current.includes(beforeSemicolon);
            postUrl.current = postUrl.current?.replace(x ? afterSemicolon : y ? beforeSemicolon : `&attributes=${withoutSemicolon}`, "")
        }
    }
    return postUrl
}

export const replaceStringByRange = (originalString, startIndex, endIndex, replacement) => {
    if (startIndex < 0 || endIndex > originalString.length || startIndex > endIndex) {
      return originalString;
    }
    const substringBefore = originalString.substring(0, startIndex);
    const substringAfter = originalString.substring(endIndex);
  
    const replacedString = substringBefore + replacement + substringAfter;
  
    return replacedString;
  }